#include <io.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <string>
using namespace std;

bool save_file(char * name, char * buf, unsigned size);

struct convert_options
{
	int html_type;			//0-XHTML, 1- HTML, 2-HTML+CSS
	char title[120];		//Page title	
	char extension[10];		//for example, ".html"
	char font_face[50];		//for example, "Arial" or "Times New Roman"
	char font_size[10];		//for example ,"10"
	int preserve_images;	//0-no, 1 - yes 
	int preserve_font_face; //0-no, 1 - yes 
	int preserve_font_size; //0-no, 1 - yes 
	int preserve_font_color;//0-no, 1 - yes 
	int preserve_hyperlinks;//0-no, 1 - yes
	int table_borders;		//0-invisble, 1 - visible
	int encoding;			/* 	Windows_1250=0, Windows_1251=1, Windows_1252=2, Windows_1253=3,
								Windows_1254=4, Windows_1255=5, Windows_1256=6, Windows_1257=7,
								Windows_1258=8, ISO_8859_1=9,	ISO_8859_2=10,	ISO_8859_3=11,
								ISO_8859_4=12,	ISO_8859_5=13,	ISO_8859_6=14,	ISO_8859_7=15,
								ISO_8859_8=16,	ISO_8859_9=17,	KOI8_R=18,		UTF_8=19	*/
	int html_parts;			//0-html Complete, 1 - only between <body>..</body>
	char image_folder[500];	//folder where image will be stored
};
 
typedef char * (* cfuncstring)(char * html, char * rtf, struct convert_options);
cfuncstring rtftohtml_string;

int main(void) 
{	

	char rtffile[_MAX_PATH];
	char htmlfile[_MAX_PATH];
	//load library
	HINSTANCE hMod=LoadLibrary("rtftohtml_sautinsoft.dll");

	if(hMod==NULL) 
	{
	  printf("Unable to load library\n");
	  getchar();
	  return 0;
	}
	rtftohtml_string=(cfuncstring)GetProcAddress(hMod,"rtftohtml_string");
	if (rtftohtml_string==NULL)
	{
		printf("Can't load function.\n");
		FreeLibrary((HMODULE)hMod);
		getchar();
		return 0;
	}
	
	int in;
	unsigned size;
	unsigned bytes;
	struct _stat st;
	char * strHtml=NULL;
	char * strRtf=NULL;


	// open html-file
	printf("Please enter rtf file (example: d:\\my.rtf):\n");
	gets(rtffile);
	// open html-file
	printf("Please enter html file (example: d:\\my.html):\n");
	gets(htmlfile);

	if ((in=open(rtffile, O_RDONLY|O_TEXT))==-1)
	{
		printf("Can't open %s file\n",rtffile);
		getchar();
		return 0;
	}
	// allocate memory
	_fstat(in,&st);
	size=st.st_size;

	if ((strRtf = (char *) malloc(size*sizeof(char)+1000))==NULL)
	{
		puts("Not enougth memory");
		getchar();
		return 0;
	}

	// reading html-file
	if ((bytes=_read(in,strRtf,size))==0)
	{
		puts("File has zero length");
		getchar();
		return 0;
	}
	
	// RTF to HTML
	strRtf[bytes]='\0';


	struct convert_options ct;
	ct.encoding=9;
	strcpy(ct.extension,".htm");
	strcpy(ct.font_face,"Verdana");
	strcpy(ct.font_size,"10");
	ct.html_type=1;
	ct.preserve_font_color=1;
	ct.preserve_font_face=1;
	ct.preserve_font_size=1;
	ct.preserve_images=1;
	ct.table_borders=1;
	ct.html_parts=1; //only between <body>...</body>
	strcpy(ct.title,"My Page");


	strHtml=(rtftohtml_string(strRtf,strHtml,ct));

	save_file(htmlfile,strHtml,strlen(strHtml));
	FreeLibrary((HMODULE)hMod);
	free(strRtf);
	return 0;
}
bool save_file(char * name, char * buf, unsigned size)
{
	FILE * fp;
	if ((fp=fopen(name,"wt"))==NULL)
		return false;

	fwrite(buf,1,size,fp);
	fclose(fp);
	return true;
}